package com.ElyStudio.leGaou.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.material.card.MaterialCardView;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.activities.GameWebViewScreen;
import com.ElyStudio.leGaou.models.Games;
import com.ElyStudio.leGaou.utilities.Constants;
import com.squareup.picasso.Picasso;

import java.util.List;

public class GamesAdapter extends RecyclerView.Adapter<GamesAdapter.GamesViewHolder> {

    private final Context context;
    private final Activity activity;
    private final List<Games> gamesList;
    private final int adEnabled;
    private final String interstitialAdId;

    public GamesAdapter(Context context, Activity activity, List<Games> gamesList, int adEnabled, String interstitialAdId) {
        this.context = context;
        this.activity = activity;
        this.gamesList = gamesList;
        this.adEnabled = adEnabled;
        this.interstitialAdId = interstitialAdId;
    }

    private InterstitialAd mInterstitialAd;
    public static final String TAG = "GAMES_ADAPTER";

    @NonNull
    @Override
    public GamesAdapter.GamesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new GamesViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.game_card_layout, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull GamesAdapter.GamesViewHolder holder, int position) {
        Games games = gamesList.get(position);
        loadInterstitialAd();

        int textColor;
        int cardBgColor;

        if(games.getColorCode() == 1)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_1);
            cardBgColor = context.getResources().getColor(R.color.quiz_color_bg_1);
        }
        else if(games.getColorCode() == 2)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_2);
            cardBgColor = context.getResources().getColor(R.color.quiz_color_bg_2);
        }
        else if(games.getColorCode() == 3)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_3);
            cardBgColor = context.getResources().getColor(R.color.quiz_color_bg_3);
        }
        else if(games.getColorCode() == 4)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_4);
            cardBgColor = context.getResources().getColor(R.color.quiz_color_bg_4);
        }
        else if(games.getColorCode() == 5)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_5);
            cardBgColor = context.getResources().getColor(R.color.quiz_color_bg_5);
        }
        else if(games.getColorCode() == 6)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_6);
            cardBgColor = context.getResources().getColor(R.color.quiz_color_bg_6);
        }
        else if(games.getColorCode() == 7)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_7);
            cardBgColor = context.getResources().getColor(R.color.quiz_color_bg_7);
        }
        else if(games.getColorCode() == 8)
        {
            textColor = context.getResources().getColor(R.color.quiz_color_text_8);
            cardBgColor = context.getResources().getColor(R.color.quiz_color_bg_8);
        }
        else
        {
            textColor = context.getResources().getColor(R.color.primary_text_color);
            cardBgColor = context.getResources().getColor(R.color.quiz_color_bg_default);
        }

        if(!games.getBgImage().trim().equals(""))
        {
            Picasso.get().load(Constants.ADMIN_PANEL_URL+games.getBgImage()).into(holder.gameBg);
        }
        else
        {
            holder.gameBg.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.image_placeholder));
        }
        holder.gameCard.setCardBackgroundColor(cardBgColor);
        holder.gameName.setText(games.getName());
        holder.gameName.setTextColor(textColor);

        holder.gameCard.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(mInterstitialAd != null)
                {
                    mInterstitialAd.show(activity);

                    mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                        @Override
                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            startGame(games);
                        }
                    });
                }
                else
                {
                    startGame(games);
                }
            }
        });
    }

    @Override
    public int getItemCount() {
        if(gamesList.size() != 0)
        return gamesList.size();
        else
            return 0;
    }

    public static class GamesViewHolder extends RecyclerView.ViewHolder {
        TextView gameName;
        ImageView gameBg;
        MaterialCardView gameCard;
        public GamesViewHolder(@NonNull View itemView) {
            super(itemView);

            gameName = itemView.findViewById(R.id.gameName);
            gameBg = itemView.findViewById(R.id.gameBg);
            gameCard = itemView.findViewById(R.id.gameCard);
        }
    }

    private void loadInterstitialAd(){

        if(adEnabled == 1) {

            AdRequest adRequest = new AdRequest.Builder().build();

            InterstitialAd.load(context, interstitialAdId, adRequest, new InterstitialAdLoadCallback() {
                @Override
                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d(TAG, "Failed to load interstitial ad = " + loadAdError);
                    mInterstitialAd = null;
                }

                @Override
                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded(interstitialAd);
                    mInterstitialAd = interstitialAd;
                }
            });
        }


    }
    private void startGame(Games games){
        Intent intent = new Intent(context, GameWebViewScreen.class);
        intent.putExtra(Constants.gameUrl,games.getGameUrl());
        intent.putExtra(Constants.gameName,games.getName());
        intent.putExtra(Constants.adEnabled,adEnabled);
        intent.putExtra(Constants.interstitialAdId,interstitialAdId);
        context.startActivity(intent);
    }
}
